(define/contract (is-bipartite graph)
  (-> (listof (listof exact-integer?)) boolean?)
  (define n (length graph))
  (define color (make-vector n -1))
  (define (bfs start)
    (define q (make-queue))
    (enqueue! q start)
    (vector-set! color start 0)
    (let loop ()
      (unless (queue-empty? q)
        (define u (dequeue! q))
        (for ([v (in-list (list-ref graph u))])
          (cond
            [(= (vector-ref color v) -1)
             (vector-set! color v (- 1 (vector-ref color u)))
             (enqueue! q v)]
            [(= (vector-ref color v) (vector-ref color u))
             #f]
            [else (void)]))
        (loop))))
  (for ([i (in-range n)])
    (when (= (vector-ref color i) -1)
      (unless (bfs i)
        (return #f)))))
  #t)